;---------------------------------
GPCD9340Ax		.EQU		1
;---------------------------------

;==========================================================================
;Version history:
;==========================================================================
;2010/01/14     First edition
;2010/01/28	Modify the comment of P_DAC_Ctrl
;2010/04/27     Revise "Quadtree" as "Quadrature"
;               Add new bodies, GPCD3040A, GPCD3080A, GPCD6040A, GPCD6080A, GPCD9040A and GPCD9080A
;               The port definitions of IOC, IOD, SPI and ADC are defined separately by various bodies
;2010/07/21     Revise the macros "%TurnOnDAC" and "%TurnOffDAC"
;2011/01/21     Add new bodies, GPCD6220A, GPCD6300A, GPCD9220A and GPCD9300A
;==========================================================================
;Declaration of SPU Channel for GPCD3 Series
;==========================================================================
        .IFDEF  GPCD3040Ax
D_ChannelNo:            .EQU    1
        .ENDIF

        .IFDEF  GPCD3080Ax
D_ChannelNo:            .EQU    1
        .ENDIF

        .IFDEF  GPCD3130Ax
D_ChannelNo:            .EQU    1
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD3170Ax
D_ChannelNo:            .EQU    1
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD3270Ax
D_ChannelNo:            .EQU    1
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD3340Ax
D_ChannelNo:            .EQU    1
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF
;==========================================================================
;Declaration of SPU Channel for GPCD6 Series
;==========================================================================
        .IFDEF  GPCD6040Ax
D_ChannelNo:            .EQU    4
        .ENDIF

        .IFDEF  GPCD6080Ax
D_ChannelNo:            .EQU    4
        .ENDIF

        .IFDEF  GPCD6130Ax
D_ChannelNo:            .EQU    4
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD6170Ax
D_ChannelNo:            .EQU    4
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD6220Ax
D_ChannelNo:            .EQU    4
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD6270Ax
D_ChannelNo:            .EQU    4
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD6300Ax
D_ChannelNo:            .EQU    4
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD6340Ax
D_ChannelNo:            .EQU    4
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF
;==========================================================================
;Declaration of SPU Channel for GPCD9 Series
;==========================================================================
        .IFDEF  GPCD9040Ax
D_ChannelNo:            .EQU    8
        .ENDIF

        .IFDEF  GPCD9080Ax
D_ChannelNo:            .EQU    8
        .ENDIF

        .IFDEF  GPCD9130Ax
D_ChannelNo:            .EQU    8
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD9170Ax
D_ChannelNo:            .EQU    8
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD9220Ax
D_ChannelNo:            .EQU    8
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD9270Ax
D_ChannelNo:            .EQU    8
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD9300Ax
D_ChannelNo:            .EQU    8
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD9340Ax
D_ChannelNo:            .EQU    8
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
        .ENDIF

        .IFDEF  GPCD9001Ax_512KB
D_ChannelNo:            .EQU    8
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
P_ADC_Setup:            .EQU    3A0H            ;ADC setup control
P_ADC_Ctrl:             .EQU    3A1H            ;ADC control register
P_ADC_DataH:            .EQU    3A2H            ;ADC Data[9:2]
P_ADC_DataL:            .EQU    3A3H            ;ADC Data[1:0]
        .ENDIF

        .IFDEF  GPCD9001Ax_1MB
D_ChannelNo:            .EQU    8
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
P_ADC_Setup:            .EQU    3A0H            ;ADC setup control
P_ADC_Ctrl:             .EQU    3A1H            ;ADC control register
P_ADC_DataH:            .EQU    3A2H            ;ADC Data[9:2]
P_ADC_DataL:            .EQU    3A3H            ;ADC Data[1:0]
        .ENDIF

        .IFDEF  GPCD9001Ax_2MB
D_ChannelNo:            .EQU    8
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
P_ADC_Setup:            .EQU    3A0H            ;ADC setup control
P_ADC_Ctrl:             .EQU    3A1H            ;ADC control register
P_ADC_DataH:            .EQU    3A2H            ;ADC Data[9:2]
P_ADC_DataL:            .EQU    3A3H            ;ADC Data[1:0]
        .ENDIF

        .IFDEF  GPCD9001Ax_4MB
D_ChannelNo:            .EQU    8
P_IOC_Data:             .EQU    308H            ;IOC data register
P_IOC_Buf:              .EQU    309H            ;IOC buffer register
P_IOC_Dir:              .EQU    30AH            ;IOC direction register
P_IOC_Att:              .EQU    30BH            ;IOC attribution register
P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
P_IOD_Data:             .EQU    30CH            ;IOD data register
P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
P_IOD_Dir:              .EQU    30EH            ;IOD direction register
P_IOD_Att:              .EQU    30FH            ;IOD attribution register
P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_SPI_Ctrl:             .EQU    380H            ;SPI control register
P_SPI_TX_Reg:           .EQU    381H            ;TX control register
P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)
P_SPI_RX_Reg:           .EQU    383H            ;RX control register
P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)
P_SPI_Setup:            .EQU    385H            ;SPI setup register
P_ADC_Setup:            .EQU    3A0H            ;ADC setup control
P_ADC_Ctrl:             .EQU    3A1H            ;ADC control register
P_ADC_DataH:            .EQU    3A2H            ;ADC Data[9:2]
P_ADC_DataL:            .EQU    3A3H            ;ADC Data[1:0]
        .ENDIF
;==========================================================================
;RAM for SPU
;==========================================================================
R_Ch0PhAddL:            .EQU    00H
R_Ch0PhAddH:            .EQU    01H
R_Ch0FsL:               .EQU    02H
R_Ch0FsH:               .EQU    03H
R_Ch0DPTRL:             .EQU    04H
R_Ch0DPTRM:             .EQU    05H
R_Ch0DPTRH:             .EQU    06H
R_Ch0LpLenL:            .EQU    07H
R_Ch0S2:                .EQU    08H
R_Ch0LpLenH:            .EQU    09H
R_Ch0VolCtl:            .EQU    0AH
R_Ch0S1:                .EQU    0BH
R_Ch0DPTNL:             .EQU    0CH
R_Ch0DPTNM:             .EQU    0DH
R_Ch0DPTNH:             .EQU    0EH
R_Ch0VolN:              .EQU    0FH
;==========================================================================
        .IF     D_ChannelNo > 1
R_Ch1PhAddL:            .EQU    10H
R_Ch1PhAddH:            .EQU    11H
R_Ch1FsL:               .EQU    12H
R_Ch1FsH:               .EQU    13H
R_Ch1DPTRL:             .EQU    14H
R_Ch1DPTRM:             .EQU    15H
R_Ch1DPTRH:             .EQU    16H
R_Ch1LpLenL:            .EQU    17H
R_Ch1S2:                .EQU    18H
R_Ch1LpLenH:            .EQU    19H
R_Ch1VolCtl:            .EQU    1AH
R_Ch1S1:                .EQU    1BH
R_Ch1DPTNL:             .EQU    1CH
R_Ch1DPTNM:             .EQU    1DH
R_Ch1DPTNH:             .EQU    1EH
R_Ch1VolN:              .EQU    1FH
;==========================================================================
R_Ch2PhAddL:            .EQU    20H
R_Ch2PhAddH:            .EQU    21H
R_Ch2FsL:               .EQU    22H
R_Ch2FsH:               .EQU    23H
R_Ch2DPTRL:             .EQU    24H
R_Ch2DPTRM:             .EQU    25H
R_Ch2DPTRH:             .EQU    26H
R_Ch2LpLenL:            .EQU    27H
R_Ch2S2:                .EQU    28H
R_Ch2LpLenH:            .EQU    29H
R_Ch2VolCtl:            .EQU    2AH
R_Ch2S1:                .EQU    2BH
R_Ch2DPTNL:             .EQU    2CH
R_Ch2DPTNM:             .EQU    2DH
R_Ch2DPTNH:             .EQU    2EH
R_Ch2VolN:              .EQU    2FH
;==========================================================================
R_Ch3PhAddL:            .EQU    30H
R_Ch3PhAddH:            .EQU    31H
R_Ch3FsL:               .EQU    32H
R_Ch3FsH:               .EQU    33H
R_Ch3DPTRL:             .EQU    34H
R_Ch3DPTRM:             .EQU    35H
R_Ch3DPTRH:             .EQU    36H
R_Ch3LpLenL:            .EQU    37H
R_Ch3S2:                .EQU    38H
R_Ch3LpLenH:            .EQU    39H
R_Ch3VolCtl:            .EQU    3AH
R_Ch3S1:                .EQU    3BH
R_Ch3DPTNL:             .EQU    3CH
R_Ch3DPTNM:             .EQU    3DH
R_Ch3DPTNH:             .EQU    3EH
R_Ch3VolN:              .EQU    3FH
        .ENDIF
;==========================================================================
        .IF     D_ChannelNo > 4
R_Ch4PhAddL:            .EQU    40H
R_Ch4PhAddH:            .EQU    41H
R_Ch4FsL:               .EQU    42H
R_Ch4FsH:               .EQU    43H
R_Ch4DPTRL:             .EQU    44H
R_Ch4DPTRM:             .EQU    45H
R_Ch4DPTRH:             .EQU    46H
R_Ch4LpLenL:            .EQU    47H
R_Ch4S2:                .EQU    48H
R_Ch4LpLenH:            .EQU    49H
R_Ch4VolCtl:            .EQU    4AH
R_Ch4S1:                .EQU    4BH
R_Ch4DPTNL:             .EQU    4CH
R_Ch4DPTNM:             .EQU    4DH
R_Ch4DPTNH:             .EQU    4EH
R_Ch4VolN:              .EQU    4FH
;==========================================================================
R_Ch5PhAddL:            .EQU    50H
R_Ch5PhAddH:            .EQU    51H
R_Ch5FsL:               .EQU    52H
R_Ch5FsH:               .EQU    53H
R_Ch5DPTRL:             .EQU    54H
R_Ch5DPTRM:             .EQU    55H
R_Ch5DPTRH:             .EQU    56H
R_Ch5LpLenL:            .EQU    57H
R_Ch5S2:                .EQU    58H
R_Ch5LpLenH:            .EQU    59H
R_Ch5VolCtl:            .EQU    5AH
R_Ch5S1:                .EQU    5BH
R_Ch5DPTNL:             .EQU    5CH
R_Ch5DPTNM:             .EQU    5DH
R_Ch5DPTNH:             .EQU    5EH
R_Ch5VolN:              .EQU    5FH
;==========================================================================
R_Ch6PhAddL:            .EQU    60H
R_Ch6PhAddH:            .EQU    61H
R_Ch6FsL:               .EQU    62H
R_Ch6FsH:               .EQU    63H
R_Ch6DPTRL:             .EQU    64H
R_Ch6DPTRM:             .EQU    65H
R_Ch6DPTRH:             .EQU    66H
R_Ch6LpLenL:            .EQU    67H
R_Ch6S2:                .EQU    68H
R_Ch6LpLenH:            .EQU    69H
R_Ch6VolCtl:            .EQU    6AH
R_Ch6S1:                .EQU    6BH
R_Ch6DPTNL:             .EQU    6CH
R_Ch6DPTNM:             .EQU    6DH
R_Ch6DPTNH:             .EQU    6EH
R_Ch6VolN:              .EQU    6FH
;==========================================================================
R_Ch7PhAddL:            .EQU    70H
R_Ch7PhAddH:            .EQU    71H
R_Ch7FsL:               .EQU    72H
R_Ch7FsH:               .EQU    73H
R_Ch7DPTRL:             .EQU    74H
R_Ch7DPTRM:             .EQU    75H
R_Ch7DPTRH:             .EQU    76H
R_Ch7LpLenL:            .EQU    77H
R_Ch7S2:                .EQU    78H
R_Ch7LpLenH:            .EQU    79H
R_Ch7VolCtl:            .EQU    7AH
R_Ch7S1:                .EQU    7BH
R_Ch7DPTNL:             .EQU    7CH
R_Ch7DPTNM:             .EQU    7DH
R_Ch7DPTNH:             .EQU    7EH
R_Ch7VolN:              .EQU    7FH
        .ENDIF
;==========================================================================
;I/O Ports
;==========================================================================
P_IOA_Data:             .EQU    300H            ;IOA data register
P_IOA_Buf:              .EQU    301H            ;IOA buffer register
P_IOA_Dir:              .EQU    302H            ;IOA direction register
P_IOA_Att:              .EQU    303H            ;IOA attribution register

P_IOB_Data:             .EQU    304H            ;IOB data register
P_IOB_Buf:              .EQU    305H            ;IOB buffer register
P_IOB_Dir:              .EQU    306H            ;IOB direction register
P_IOB_Att:              .EQU    307H            ;IOB attribution register

;P_IOC_Data:             .EQU    308H            ;IOC data register
;P_IOC_Buf:              .EQU    309H            ;IOC buffer register
;P_IOC_Dir:              .EQU    30AH            ;IOC direction register
;P_IOC_Att:              .EQU    30BH            ;IOC attribution register

;P_IOD_Data:             .EQU    30CH            ;IOD data register
;P_IOD_Buf:              .EQU    30DH            ;IOD buffer register
;P_IOD_Dir:              .EQU    30EH            ;IOD direction register
;P_IOD_Att:              .EQU    30FH            ;IOD attribution register
;==========================================================================
;Special Functions
;==========================================================================
P_SF_Ctrl:              .EQU    312H            ;Special function control register
 D_32K_Enable:          .EQU    00000001B       ;Enable 32768Hz crystal
 D_32K_Strong:          .EQU    00000010B       ;32768Hz crystal operates in strong mode
 D_IR_DutyBy2:          .EQU    00000000B       ;IR output with 1/2 duty
 D_IR_DutyBy3:          .EQU    00000100B       ;IR output with 1/3 duty
 D_IR_DutyBy4:          .EQU    00001000B       ;IR output with 1/4 duty
 D_IR_DutyBy5:          .EQU    00001100B       ;IR output with 1/5 duty
 D_IR_Enable:           .EQU    00010000B       ;IR enable bit
 D_ExtBothEdge:         .EQU    01000000B       ;External interrupt with both edge (Falling and Rising)
 D_ExtIntCtrl:          .EQU    10000000B       ;External interrupt control
;==========================================================================
;Control Register of I/O Key Change
;==========================================================================
P_IOA_KEY_State:        .EQU    313H            ;IOA key change state
P_IOB_KEY_State:        .EQU    314H            ;IOB key change state
;P_IOC_KEY_State:        .EQU    315H            ;IOC key change state
;P_IOD_KEY_State:        .EQU    316H            ;IOD key change state
P_IO_KEY_Source:        .EQU    317H            ;Control register of I/O key change source
 D_IOA_KEY:             .EQU    00000001B       ;Enable IOA for I/O key change interrupt
 D_IOB_KEY:             .EQU    00000010B       ;Enable IOB for I/O key change interrupt
 D_IOC_KEY:             .EQU    00000100B       ;Enable IOC for I/O key change interrupt
 D_IOD_KEY:             .EQU    00001000B       ;Enable IOD for I/O key change interrupt
;==========================================================================
P_RTC_Clr:              .EQU    318H
;==========================================================================
P_SYS_Ctrl:             .EQU    319H
 D_NoDebounce:          .EQU    00000000B       ;No debouncing when woken up by I/O key change
 D_Debounce170uS:       .EQU    00000001B       ;170uS debouncing on 12MHz system clock when woken up by I/O key change
 D_Debounce22mS:        .EQU    00000010B       ;22mS debouncing on 12MHz system clock when woken up by I/O key change
 D_IOA_SCH_En:          .EQU    00010000B       ;Enable IOA Schmitt trigger
 D_IOB_SCH_En:          .EQU    00100000B       ;Enable IOB Schmitt trigger
 D_IOC_SCH_En:          .EQU    01000000B       ;Enable IOC Schmitt trigger
 D_IOD_SCH_En:          .EQU    10000000B       ;Enable IOD Schmitt trigger
;==========================================================================
;ROM Bank Port
;==========================================================================
P_Bank:                 .EQU    320H            ;Bank control
;==========================================================================
;Status Register
;==========================================================================
P_State:                .EQU    321H            ;Reset state flags (Read only)
 D_Software_Reset:      .EQU    00000001B       ;It will be set if software reset is issued
 D_WDT_Reset:           .EQU    00000010B       ;It will be set if watchdog timer reset is issued
 D_Illegal_Reset:       .EQU    00000100B       ;It will be set if illegal address reset is issued
;==========================================================================
;Watchdog Timer Clear Port
;==========================================================================
P_WDT_Clr:              .EQU    322H            ;Write 55H to clear WDT
;==========================================================================
;Sleep Control
;==========================================================================
P_Sleep:                .EQU    323H            ;Sleep control port
;==========================================================================
;NMI Control
;==========================================================================
P_NMI_Enable:           .EQU    324H            ;Write any data to enable NMI
P_NMI_Disable:          .EQU    325H            ;Write any data to disable NMI
;==========================================================================
;Low Voltage Detection (LVD)
;==========================================================================
P_LVD:                  .EQU    326H            ;Control register of low voltage detection
 D_LVD_2V4:             .EQU    00000001B       ;LVD flag will be set if power is smaller than 2.4V
 D_LVD_2V6:             .EQU    00000010B       ;LVD flag will be set if power is smaller than 2.6V
 D_LVD_2V8:             .EQU    00000011B       ;LVD flag will be set if power is smaller than 2.8V
 D_LVD_Status:          .EQU    00000100B       ;It will be set if power is smaller than LVD voltage
;==========================================================================
;Timer A
;==========================================================================
P_TMA_Ctrl:             .EQU    330H            ;Control register for timer
P_TMA_CC_Ctrl:          .EQU    331H            ;Control register for Capture/Comparison function
P_TMA_DataH:            .EQU    332H            ;Data high byte
P_TMA_DataL:            .EQU    333H            ;Data low byte
P_TMA_CCH:              .EQU    334H            ;CAP/CMP counter register high byte
P_TMA_CCL:              .EQU    335H            ;CAP/CMP counter register high byte
P_TMA_CntH:             .EQU    336H            ;Counter high byte
P_TMA_CntL:             .EQU    337H            ;Counter low byte
;==========================================================================
;Timer B
;==========================================================================
P_TMB_Ctrl:             .EQU    338H            ;Control register for timer
P_TMB_CMP_Ctrl:         .EQU    339H            ;Control register for Comparison function
P_TMB_DataH:            .EQU    33AH            ;Data high byte
P_TMB_DataL:            .EQU    33BH            ;Data low byte
P_TMB_CMPH:             .EQU    33CH            ;CMP counter register high byte
P_TMB_CMPL:             .EQU    33DH            ;CMP counter register low byte
P_TMB_CntH:             .EQU    33EH            ;Counter high byte
P_TMB_CntL:             .EQU    33FH            ;Counter low byte
;==========================================================================
;Timer C
;==========================================================================
P_TMC_Ctrl:             .EQU    340H            ;Control register for timer
P_TMC_CMP_Ctrl:         .EQU    341H            ;Control register for Comparison function
P_TMC_DataH:            .EQU    342H            ;Data high byte
P_TMC_DataL:            .EQU    343H            ;Data low byte
P_TMC_CMPH:             .EQU    344H            ;CMP counter register high byte
P_TMC_CMPL:             .EQU    345H            ;CMP counter register low byte
P_TMC_CntH:             .EQU    346H            ;Counter high byte
P_TMC_CntL:             .EQU    347H            ;Counter low byte
;==========================================================================
;Timer Source Definition
;==========================================================================
 D_S1_Fcpu:             .EQU    00000000B       ;Source 1 = Fcpu
 D_S1_FcpuBy8:          .EQU    00000001B       ;Source 1 = Fcpu/8
 D_S1_FcpuBy32:         .EQU    00000010B       ;Source 1 = Fcpu/32
 D_S1_FcpuBy256:        .EQU    00000011B       ;Source 1 = Fcpu/256
 D_S1_32768Hz:          .EQU    00000100B       ;Source 1 = 32768Hz (Replaced by Fcpu/128 if 312H[0] = 0)
 D_S1_0:                .EQU    00000101B       ;Source 1 = 0
 D_S1_1:                .EQU    00000110B       ;Source 1 = 1
 D_S1_EXT:              .EQU    00000111B       ;Source 1 = External clock
 D_S2_1:                .EQU    00000000B       ;Source 2 = 1
 D_S2_2Hz:              .EQU    00001000B       ;Source 2 = 2Hz (Replaced by Fcpu/2097152 if 312H[0] = 0)
 D_S2_16Hz:             .EQU    00010000B       ;Source 2 = 16Hz (Replaced by Fcpu/262144 if 312H[0] = 0)
 D_S2_EXT:              .EQU    00011000B       ;Source 2 = External clock
 D_TMR_Disable:         .EQU    00000000B       ;Disable timer
 D_TMR_Enable:          .EQU    10000000B       ;Enable timer
;==========================================================================
;Capture/Comparison Definition
;==========================================================================
 D_CC_Sel:              .EQU    00000011B       ;Capture/Comparison selection bit
 D_CC_None:             .EQU    00000000B       ;Disable capture/comparison
 D_CC_CAP:              .EQU    00000001B       ;Enable capture mode
 D_CC_CMP:              .EQU    00000010B       ;Enable comparison mode
 D_CAP_Falling:         .EQU    00000000B       ;Set capture mode as falling edge
 D_CAP_Rising:          .EQU    00000100B       ;Set capture mode as rising edge
 D_CMP_PWMOut:          .EQU    00000000B       ;Output PWM via comparison mode
 D_CMP_FixedOut:        .EQU    00001000B       ;Output fixed state via comparison mode
 D_CC_IO_Sel:           .EQU    00110000B       ;I/O selection for capture/comparison
 D_CC_IO_None:          .EQU    00000000B       ;No I/O is selected
 D_CC_IO_IOA:           .EQU    00010000B       ;Select IOA for capture/comparison
 D_CC_IO_IOB:           .EQU    00100000B       ;Select IOB for capture/comparison
 D_CC_IO_IOAB:          .EQU    00110000B       ;Select IOA and IOB for capture/comparison
;==========================================================================
;Interrupt Control
;==========================================================================
P_INT_CtrlL:            .EQU    350H            ;Interrupt control register low byte
 D_KeyIntEn:            .EQU    00000001B       ;Enable I/O key change IRQ
 D_RTC2HzIntEn:         .EQU    00000010B       ;Enable RTC 2Hz IRQ
 D_RTC16HzIntEn:        .EQU    00000100B       ;Enable RTC 16Hz IRQ
 D_TB4096IntEn:         .EQU    00001000B       ;Enable Fcpu/4096 IRQ
 D_TB1024IntEn:         .EQU    00010000B       ;Enable Fcpu/1024 IRQ
 D_TMCIntEn:            .EQU    00100000B       ;Enable Timer C IRQ
 D_TMBIntEn:            .EQU    01000000B       ;Enable Timer B IRQ
 D_TMAIntEn:            .EQU    10000000B       ;Enable Timer A IRQ

P_INT_CtrlH:            .EQU    351H            ;Interrupt control register high byte
 D_NMI_None:            .EQU    00000000B       ;None NMI source
 D_NMI_TMA:             .EQU    00000001B       ;Timer A as NMI source
 D_NMI_TMB:             .EQU    00000010B       ;Timer B as NMI source
 D_NMI_TMC:             .EQU    00000011B       ;Timer C as NMI source
 D_NMI_TB1024:          .EQU    00000100B       ;Fcpu/1024 as NMI source
 D_NMI_TB4096:          .EQU    00000101B       ;Fcpu/4096 as NMI source
 D_NMI_Key:             .EQU    00000110B       ;I/O key change as NMI source
 D_NMI_Ext:             .EQU    00000111B       ;External interrupt as NMI source
 D_QD2IntEn:            .EQU    00001000B       ;Enable Quadrature Decoder 2 IRQ
 D_QD1IntEn:            .EQU    00010000B       ;Enable Quadrature Decoder 1 IRQ
 D_SPIIntEn:            .EQU    00100000B       ;Enable SPI IRQ
 D_SPUIntEn:            .EQU    01000000B       ;Enable SPU IRQ
 D_ExtIntEn:            .EQU    10000000B       ;Enable External interrupt IRQ
;==========================================================================
;Interrupt Status
;==========================================================================
P_INT_StatusL:          .EQU    352H            ;Write "1" to clear
 D_KeyIntFlag:          .EQU    00000001B       ;I/O key change interrupt flag
 D_RTC2HzIntFlag:       .EQU    00000010B       ;RTC 2Hz interrupt flag
 D_RTC16HzIntFlag:      .EQU    00000100B       ;RTC 16Hz interrupt flag
 D_TB4096IntFlag:       .EQU    00001000B       ;Fcpu/4096 interrupt flag
 D_TB1024IntFlag:       .EQU    00010000B       ;Fcpu/1024 interrupt flag
 D_TMCIntFlag:          .EQU    00100000B       ;Timer C interrupt flag
 D_TMBIntFlag:          .EQU    01000000B       ;Timer B interrupt flag
 D_TMAIntFlag:          .EQU    10000000B       ;Timer A interrupt flag

P_INT_StatusH:          .EQU    353H            ;Write "1" to clear
 D_QD2BwIntFlag:        .EQU    00000001B       ;Quadrature Decoder 2 backward interrupt flag
 D_QD2FwIntFlag:        .EQU    00000010B       ;Quadrature Decoder 2 forward interrupt flag
 D_QD1BwIntFlag:        .EQU    00000100B       ;Quadrature Decoder 1 backward interrupt flag
 D_QD1FwIntFlag:        .EQU    00001000B       ;Quadrature Decoder 1 forward interrupt flag
 D_SPIIntFlag:          .EQU    00100000B       ;SPI interrupt flag
 D_SPUIntFlag:          .EQU    01000000B       ;SPU interrupt flag
 D_ExtIntFlag:          .EQU    10000000B       ;External interrupt flag
;==========================================================================
;Interrupt Clear Ports
;==========================================================================
P_TMA_Clr:              .EQU    354H            ;Write any data to clear Timer A interrupt flag
P_TMB_Clr:              .EQU    355H            ;Write any data to clear Timer B interrupt flag
P_TMC_Clr:              .EQU    356H            ;Write any data to clear Timer C interrupt flag
P_1024_Clr:             .EQU    357H            ;Write any data to clear Fcpu/1024 interrupt flag
P_4096_Clr:             .EQU    358H            ;Write any data to clear Fcpu/4096 interrupt flag
P_16Hz_Clr:             .EQU    359H            ;Write any data to clear RTC 16Hz interrupt flag
P_2Hz_Clr:              .EQU    35AH            ;Write any data to clear RTC 2Hz interrupt flag
P_KEY_Clr:              .EQU    35BH            ;Write any data to clear I/O key change interrupt flag
P_EXT_Clr:              .EQU    35CH            ;Write any data to clear external interrupt flag
;==========================================================================
;SPU Control
;==========================================================================
P_MainVol:              .EQU    361H            ;Main volume control for SPU channels
 D_FullSwing:           .EQU    10000000B       ;Full swing for SPU channels
P_Mixer:                .EQU    363H            ;Mixer control for SPU channels
P_SPU_Enable:           .EQU    364H            ;Control register of corresponding SPU channels
P_SPU_Status:           .EQU    365H            ;Interrupt status of corresponding SPU channels
P_SPU_IntCtrl:          .EQU    366H            ;Interrupt control register of corresponding SPU channels
P_SPU_Conc:             .EQU    367H            ;Control register of concatenated jump mode
;==========================================================================
;Multiplier
;==========================================================================
P_MulM:                 .EQU    368H            ;Multiplicator
P_MulF:                 .EQU    369H            ;Faciend
P_MulOutH:              .EQU    36AH            ;Result high Byte
P_MulOutL:              .EQU    36BH            ;Result low Byte
P_MulAct:               .EQU    36CH            ;Write "1" to bit0 to start multiplication
 D_MulAct:              .EQU    00000001B       ;Act bit
;==========================================================================
;SPI Control
;==========================================================================
;P_SPI_Ctrl:             .EQU    380H            ;SPI control register
 D_SPI_ClkDiv2:         .EQU    00000000B       ;CLK = Fcpu/2
 D_SPI_ClkDiv4:         .EQU    00000001B       ;CLK = Fcpu/4
 D_SPI_ClkDiv8:         .EQU    00000010B       ;CLK = Fcpu/8
 D_SPI_ClkDiv16:        .EQU    00000011B       ;CLK = Fcpu/16
 D_SPI_ClkDiv32:        .EQU    00000100B       ;CLK = Fcpu/32
 D_SPI_ClkDiv64:        .EQU    00000101B       ;CLK = Fcpu/64
 D_SPI_ClkDiv128:       .EQU    00000110B       ;CLK = Fcpu/128
 D_SPI_Polarity:        .EQU    00001000B       ;Clock polarity of master mode
 D_SPI_Phase:           .EQU    00010000B       ;Clock phase of master mode
 D_SPI_Master:          .EQU    00000000B       ;Master mode
 D_SPI_Enable:          .EQU    10000000B       ;Enable SPI

;P_SPI_TX_Reg:           .EQU    381H            ;TX control register
 D_SPI_TX_AutoCS:       .EQU    00000001B       ;Automatic mode on CS pin
 D_SPI_TX_Empty:        .EQU    00000010B       ;It will be set if TX FIFO is empty
 D_SPI_TX_NotFull:      .EQU    00000100B       ;It will be set if TX FIFO is not full
 D_SPI_TX_FIFO_Flag:    .EQU    00001000B       ;TX FIFO flag
 D_SPI_TX_FIFO_Lev:     .EQU    00010000B       ;TX FIFO setting
 D_SPI_TX_IntEn:        .EQU    01000000B       ;TX interrupt control bit
 D_SPI_TX_IntFlag:      .EQU    10000000B       ;TX interrupt flag

;P_SPI_TX_Data:          .EQU    382H            ;SPI TX data register (2-byte FIFO)

;P_SPI_RX_Reg:           .EQU    383H            ;RX control register
 D_SPI_RX_Overrun:      .EQU    00000001B       ;SPI RX FIFO overrun flag
 D_SPI_RX_Full:         .EQU    00000010B       ;It will be set if RX FIFO is full
 D_SPI_RX_NotEmpty:     .EQU    00000100B       ;It will be set if RX FIFO is not empty
 D_SPI_RX_FIFO_Flag:    .EQU    00001000B       ;RX FIFO flag
 D_SPI_RX_FIFO_Lev:     .EQU    00010000B       ;RX FIFO setting
 D_SPI_RX_IntEn:        .EQU    01000000B       ;RX interrupt control bit
 D_SPI_RX_IntFlag:      .EQU    10000000B       ;RX interrupt flag

;P_SPI_RX_Data:          .EQU    384H            ;SPI RX data register (2-byte FIFO)

;P_SPI_Setup:            .EQU    385H            ;SPI setup register
 D_SPI_Busy:            .EQU    00010000B       ;It will be set if SPI is busy
 D_SPI_SMART:           .EQU    00100000B       ;SMART function control bit
 D_SPI_Overwrite:       .EQU    01000000B       ;Overwrite control bit
 D_SPI_Reset:           .EQU    10000000B       ;Write "1" to reset SPI module
;==========================================================================
;DAC Control
;==========================================================================
P_DAC1H:                .EQU    390H            ;Software channel 1 high byte
P_DAC1L:                .EQU    391H            ;Software channel 1 low byte (Only P_DAC1L[7:2] are available)
P_DAC2H:                .EQU    392H            ;Software channel 2 high byte
P_DAC2L:                .EQU    393H            ;Software channel 2 low byte (Only P_DAC1L[7:2] are available)
P_DAC_Ctrl:             .EQU    394H            ;Control register of push-pull DAC
 D_GainLv0:             .EQU    00000000B
 D_GainLv1:             .EQU    00000001B       ;The Gain Level 1~4 are the same volume
 D_GainLv2:             .EQU    00000010B
 D_GainLv3:             .EQU    00000011B
 D_GainLv4:             .EQU    00000100B
 D_GainLv5:             .EQU    00000101B
 D_GainLv6:             .EQU    00000110B
 D_GainLv7:             .EQU    00000111B
 D_GainLv8:             .EQU    00001000B
 D_GainLv9:             .EQU    00001001B
 D_GainLvA:             .EQU    00001010B
 D_GainLvB:             .EQU    00001011B
 D_GainLvC:             .EQU    00001100B
 D_GainLvD:             .EQU    00001101B
 D_GainLvE:             .EQU    00001110B
 D_GainLvF:             .EQU    00001111B
 D_DAC_Enable:          .EQU    00010000B       ;Enable DAC
 D_OPN_En:              .EQU    00100000B       ;Enable OPN
 D_OPP_En:              .EQU    01000000B       ;Enable OPP

P_DAC1_Ctrl:            .EQU    395H            ;Control register of software channel 1
 D_DAC1_Half:           .EQU    00000001B       ;Half volume
 D_DAC1_Direct:         .EQU    00000000B       ;Software channel 1 outputs directly
 D_DAC1_Latch:          .EQU    00000010B       ;Software channel 1 outputs with timer latching
 D_DAC1_Upsampling:     .EQU    00000100B       ;Software channel 1 outputs with wave filter
 D_DAC_Scaler:          .EQU    00001000B       ;Enable Scaler function (Nonlinear output)
 D_IIS_OUT_Enable:      .EQU    01000000B       ;Enable IIS output
 D_IIS_IN_Enable:       .EQU    10000000B       ;Enable IIS input

P_DAC2_Ctrl:            .EQU    396H            ;Control register of software channel 2
 D_DAC2_Half:           .EQU    00000001B       ;Half volume
 D_DAC2_Direct:         .EQU    00000000B       ;Software channel 2 outputs directly
 D_DAC2_Latch:          .EQU    00000010B       ;Software channel 2 outputs with timer latching
 D_DAC2_Upsampling:     .EQU    00000100B       ;Software channel 2 outputs with wave filter
;==========================================================================
;ADC Control
;==========================================================================
;P_ADC_Setup:            .EQU    3A0H            ;ADC setup control
 D_ADC_ClkDiv512:       .EQU    00000000B       ;CLK = Fcpu/512
 D_ADC_ClkDiv256:       .EQU    00000001B       ;CLK = Fcpu/256
 D_ADC_ClkDiv128:       .EQU    00000010B       ;CLK = Fcpu/128
 D_ADC_ClkDiv64:        .EQU    00000011B       ;CLK = Fcpu/64
 D_ADC_ClkDiv1024:      .EQU    00000100B       ;CLK = Fcpu/1024
 D_ADC_ClkDiv2048:      .EQU    00000101B       ;CLK = Fcpu/2048
 D_ADC_Enable:          .EQU    10000000B       ;Write "1" to enable ADC

;P_ADC_Ctrl:             .EQU    3A1H            ;ADC control register
 D_ADC_LineIn0:         .EQU    00000000B       ;Input = IOC0
 D_ADC_LineIn1:         .EQU    00000001B       ;Input = IOC1
 D_ADC_LineIn2:         .EQU    00000010B       ;Input = IOC2
 D_ADC_LineIn3:         .EQU    00000011B       ;Input = IOC3
 D_ADC_LineIn4:         .EQU    00000100B       ;Input = IOC4
 D_ADC_LineIn5:         .EQU    00000101B       ;Input = IOC5
 D_ADC_LineIn6:         .EQU    00000110B       ;Input = IOC6
 D_ADC_LineIn7:         .EQU    00000111B       ;Input = IOC7
 D_ADC_Start:           .EQU    00001000B       ;Write "1" to start ADC to convert
 D_ADC_Idle:            .EQU    00010000B       ;Read "1" when ADC is idle
 D_ADC_IntEn:           .EQU    01000000B       ;ADC interrupt control
 D_ADC_IntFlag:         .EQU    10000000B       ;Read "1" when ADC conversion is complete and write "1" to clear

;P_ADC_DataH:            .EQU    3A2H            ;ADC Data[9:2]
;P_ADC_DataL:            .EQU    3A3H            ;ADC Data[1:0]
;==========================================================================
;PWM I/O Control
;==========================================================================
P_PWMIO_Ctrl:           .EQU    3B0H            ;Control register of PWM I/O
 D_PWMIO0_En:           .EQU    00000001B       ;PWMIO0 enable
 D_PWMIO1_En:           .EQU    00000010B       ;PWMIO1 enable
 D_PWMIO2_En:           .EQU    00000100B       ;PWMIO2 enable
 D_PWMIO3_En:           .EQU    00001000B       ;PWMIO3 enable
 D_PWMIO_FcpuBy256:     .EQU    00000000B       ;Frequency = Fcpu/256
 D_PWMIO_FcpuBy64:      .EQU    00010000B       ;Frequency = Fcpu/64
 D_PWMIO_FcpuBy2:       .EQU    00100000B       ;Frequency = Fcpu/2
 D_PWMIO_ByTMC:         .EQU    00110000B       ;Frequency = Timer C overflow

P_PWMIO_Sel:            .EQU    3B1H            ;I/O Selection
 D_PWMIO0_NoOut:        .EQU    00000000B       ;PWMIO0 no output
 D_PWMIO0_IOB:          .EQU    00000010B       ;PWMIO0 outputs to IOB0
 D_PWMIO1_NoOut:        .EQU    00000000B       ;PWMIO1 no output
 D_PWMIO1_IOB:          .EQU    00001000B       ;PWMIO1 outputs to IOB1
 D_PWMIO2_NoOut:        .EQU    00000000B       ;PWMIO2 no output
 D_PWMIO2_IOB:          .EQU    00100000B       ;PWMIO2 outputs to IOB2
 D_PWMIO3_NoOut:        .EQU    00000000B       ;PWMIO3 no output
 D_PWMIO3_IOB:          .EQU    10000000B       ;PWMIO3 outputs to IOB3

P_PWMIO0_Duty:          .EQU    3B2H            ;Duty control of PWMIO0
P_PWMIO1_Duty:          .EQU    3B3H            ;Duty control of PWMIO1
P_PWMIO2_Duty:          .EQU    3B4H            ;Duty control of PWMIO2
P_PWMIO3_Duty:          .EQU    3B5H            ;Duty control of PWMIO3
;==========================================================================
;Quadrature Decoder
;==========================================================================
P_QD1_Cnt:              .EQU    3B6H            ;Counter of QD1
P_QD2_Cnt:              .EQU    3B7H            ;Counter of QD2
P_QD1_Clr:              .EQU    3B8H            ;Write any data to clear QD1 counter
P_QD2_Clr:              .EQU    3B9H            ;Write any data to clear QD2 counter
P_QD_Ctrl:              .EQU    3BAH            ;Quadrature decoder control register
 D_QD1_AllInt:          .EQU    00000000B       ;QD1 interrupt will be issued if any interrupt occurs
 D_QD1_FlowInt:         .EQU    00000001B       ;QD1 interrupt will be issued if any underflow/overflow occurs on QD1 counter
 D_QD1_Enable:          .EQU    00000010B       ;QD1 enable bit
 D_QD2_AllInt:          .EQU    00000000B       ;QD2 interrupt will be issued if any interrupt occurs
 D_QD2_FlowInt:         .EQU    00000100B       ;QD2 interrupt will be issued if any underflow/overflow occurs on QD1 counter
 D_QD2_Enable:          .EQU    00001000B       ;QD2 enable bit
;==========================================================================
D_Bit0:                 .EQU    00000001B
D_Bit1:                 .EQU    00000010B
D_Bit2:                 .EQU    00000100B
D_Bit3:                 .EQU    00001000B
D_Bit4:                 .EQU    00010000B
D_Bit5:                 .EQU    00100000B
D_Bit6:                 .EQU    01000000B
D_Bit7:                 .EQU    10000000B
;==========================================================================
%TurnOnDAC:             .MACRO
        LDA     P_DAC_Ctrl
        AND     #00001111B              ;Reserve gain control
        ORA     #(D_DAC_Enable+D_OPN_En)
        STA     P_DAC_Ctrl
        NOP
        NOP
        NOP
        NOP
        ORA     #D_OPP_En
        STA     P_DAC_Ctrl
                        .ENDM
;==========================================================================
%TurnOffDAC:            .MACRO
        LDA     P_DAC_Ctrl
        AND     #~D_OPP_En
        STA     P_DAC_Ctrl
        NOP
        NOP
        NOP
        NOP
        AND     #~(D_DAC_Enable+D_OPN_En)
        STA     P_DAC_Ctrl
                        .ENDM
;==========================================================================
%PushReg:       .MACRO
        PHA
        TXA
        PHA
        TYA
        PHA
                .ENDM
;==========================================================================
%PopReg:        .MACRO
        PLA
        TAY
        PLA
        TAX
        PLA
                .ENDM
;==========================================================================
%ClearWDT:      .MACRO                  ;Clear Watchdog Timer
        LDA     #55H
        STA     P_WDT_Clr
                .ENDM
;==========================================================================
